// http://stackoverflow.com/questions/26659042/unit-testing-a-directive-with-parsers-and-formatters
define(['angular', 'RequiredNonZeroValue'], function() {
	'use strict';
	describe('Required Non-Zero Value Directive', function () {
		var scope,
			element,
			select;

		beforeEach(function () {
			module('angularTemplateApp');

			inject(function($rootScope, $compile) {
				scope = $rootScope.$new();
				//Must be an object to make use of prototypical inheritence for outside-of-isolate-scope access
				scope.models = {};
				scope.lastSeenMenu = [
					{value: 200, days: "200"},
					{value: 100, days: "100"}
				];

				element = angular.element('<form name="directiveTestForm">' +
						'<select required required-non-zero-value name="total" ng-model="models.total" ng-options="lastSeen.value as lastSeen.days for lastSeen in lastSeenMenu">' +
							'<option value="">Select</option>' +
						'</select>' +
					'</form>');

				$compile(element)(scope);
				scope.$digest();

				select = element.find('select');
			});
		});

		describe('the parser', function () {
			it('should parse strings to ints and set non-zeros as valid', function () {
				select.find('option:last-of-type').prop('selected', true);
				select.trigger('change');
				expect(scope.models.total).toBe(100);
				expect(scope.directiveTestForm.total.$valid).toBe(true);
			});

			// tested in automated test, unable to trigger change to empty string
			// -- it 'should parse empty strings to zero values and set as invalid'
		});

		describe('the formatter', function () {
			it('should leave non-zero values as-is', function () {
				scope.models.total = 200;
				scope.$digest();
				expect(select.find('option:selected').text()).toBe('200');
			});

			it('should format 0 as null, selecting the default option', function () {
				scope.models.total = 0;
				scope.$digest();
				expect(select.find('option:selected').text()).toBe('Select');
			});
		});
	});
});